TITLE   'Ramp Function at a Boundary'		         	       { exa183a.pde }
SELECT     						
   errlim=3e-4     spectral_colors
COORDINATES
   cartesian1
VARIABLES   temp( threshold=1e-3)
DEFINITIONS
   Lx=1.0     Ly=0.1     heat=0     k     rcp		
   fluxd_x=-k*dx(temp)
   tempi=300     temp0=300+0.01*t
INITIAL VALUES
   temp=tempi
EQUATIONS
   dx( fluxd_x)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain' k=82  rcp=7.87e3*449 			{ Fe }         		
   start (0) point value(temp)=temp0  line to (Lx)
region 'copper'  k=400  rcp=8.96e3* 385       		
   start (0)  line to (0.2*Lx) to (0.2*Lx)
TIME   from 0 to 100000
PLOTS
   for t=10, 30, 100, 300, 1000, 3000, 10000, 30000, 100000
elevation( temp) from (0,Ly/2) to (Lx,Ly/2)
   elevation( fluxd_x) from (0,Ly/2) to (Lx,Ly/2)
HISTORIES
   history( temp) at (0.1*Lx) at (0.2*Lx) at (0.3*Lx)
      at (0.4*Lx) at (0.5*Lx)
END



